CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
    MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.tables WHERE UPPER(TABLE_NAME) = 'RC_RESP_TEC') THEN 
        CREATE TABLE RC_RESP_TEC (
            cd_emp INT NOT NULL,
            CNPJ_RESPTEC varchar(14) NOT NULL,
            CONTATO_RESPTEC varchar(200) NULL,
			EMAIL_RESPTEC varchar(200) NULL,
			FONE_RESPTEC varchar(20) NULL,
			DESC_CSRT varchar(100) NULL,
			CD_CSRT int NULL,
			CONSTRAINT RC_RESP_TEC_PKEY PRIMARY KEY (CD_EMP, CNPJ_RESPTEC)
        )
		WITH (OIDS=FALSE);
    ELSE    
        MSGFINAL := 'A TABELA JÁ EXISTE';
    END IF;

    RAISE NOTICE 'TABELA RC_RESP_TEC %', MSGFINAL::VARCHAR;

END; 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();